//More Menu
 (function($){
	$.fn.styleddropdown = function(){
		return this.each(function(){
			var obj = $(this);
			obj.find('.field').click(function() { 
			$(".list").fadeOut(200);
			obj.find('.list').fadeIn(400);
			
			$(document).keyup(function(event) { 
				if(event.keyCode == 27) {
				obj.find('.list').fadeOut(400);
				}
			});
			
			obj.find('.list').hover(function(){ },
				function(){
					$(this).fadeOut(400);
				});
			});
			
			obj.find('.list li').click(function() {
			obj.find('.field')
				.val($(this).html())
				.css({
					'background':'#fff',
					'color':'#333'
				});
			obj.find('.list').fadeOut(400);
			});
		});
	};
})(jQuery);

$(function(){
	$('.size').styleddropdown();
});
  
function closeDialog(id) {
	$('#'+id).dialog('close');
}

//for adhoc report name edit
function validateAdhocReportEditForm(reportId, oldName) {
	var reportName = $("#report_name_" + reportId).val();
	//var reportDescription = $("#report_description_" + reportId).val();
	var error_message = '';
	if(reportName == '' || reportName == null) {
		error_message = 'Report Name is required.<br>';
	}
	if(error_message == '') {
		clean_report_name = encodeURIComponent(reportName);
		$.ajax({
			url : '/reports/edit_report_attributes/?report_id='+reportId +'&report_name='+clean_report_name+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
			success: function(data,statusText,xhr) {
				var data_arr = $.parseJSON(data);
				var modifiedTime = '';
				$.each(data_arr, function(key, value) {
					modifiedTime = value;
				});
				//alert(time_display);
				var report_name_link_innerhtml = $('#report_name_link_' + reportId).html();
				$('#edit_report_dialog' + reportId).fadeOut('slow');
				setTimeout(function(){
					$('#edit_report_dialog' + reportId).dialog('close');
					},360);
				$('#report_name_link_' + reportId).html(report_name_link_innerhtml.replace(oldName, reportName));
				$('#modified_time' + reportId).html(modifiedTime);
				$('#report_name_link_' + reportId).effect("highlight", {}, 2500);
				//update edit report dialog window title
				$('#edit_report_dialog' + reportId).dialog('option', 'title', 'Edit Name for Ad-hoc Report: ' + reportName);
				//update user management window title
				$('#dialog' + reportId).dialog('option', 'title', reportName);
				$('#save_report_name_btn' + reportId).attr("onclick","validateAdhocReportEditForm("+reportId+",'"+reportName+"')");
				
				$('#report_table').dataTable().fnDestroy();
				initializeAdhocReportDatatable();
			}
		});
	}
	else {
		$('#error_message_div' + reportId).html(error_message);
		$('#error_message_div' + reportId).fadeIn('slow');
	}
}

function validateAdhocReportSaveForm() {
	var error_message = '';
	var selectedReportAccess = $('input[name=report_access]:checked', '#adhoc_form').val();
	
	if($("#report_name").val().length > 50) {
		error_message += 'Report Name cannot be longer than 50 charaters.<br>';
	}
	if($('#report_name').val() == '' || $('#report_name').val() == null) {
		error_message += 'Report Name is required.<br>';
	}
	if($("#report_decription").val().length > 200) {
		error_message += 'Report Description cannot be longer than 200 characters.<br>';
	}
	if(selectedReportAccess == 'share' && $('#selected_group_names').val() == '' & $('#selected_user_ids').val() == '') {
		error_message += 'Nothing has been selected to share.';
	}
	
	if(error_message == '') {
		$('#adhoc_form').submit();
	}
	else {
		$('#error_message_div').html(error_message);
		$('#error_message_div').fadeIn('slow');
	}
}

//functions and variables for share view
var selected_group_names = '';
var selected_user_ids = '';

var selectedCategoryValue = '';
var selectedCategoryText= '';

function getGroupsToShareReport(){
	$.ajax({
		url : '/reports/get_groups_to_share_report/?which_report='+which_report+'&' +$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#group_select").empty();
			$.each(data_arr, function(key, value) {
				 $('#group_select').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
			$('#group_select').on('change', function() {
				
				$(this).find('option:selected').each(
						function(){
							if($('#row_' + this.value).length <= 0 && this.value != 'multiselect-all') {
								insertRowInSelectedEntryTable(this.value, $(this).text());
							}
						}
		            );
				$(this).find('option:not(:selected)').each(
						 function(){
				            	deselectEntry(this.value, selectedCategoryValue);
				            	
						 });
				
				if($(this).val() != null) {
					$('#selected_group_names').attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_group_names').attr('value','');
				}
				
			});
			$('#group_select').multiselect({
				includeSelectAllOption: true,
				enableCaseInsensitiveFiltering: true,
	        	//enableFiltering: true,
	        	//filterBehavior: 'text',
	        	//filterPlaceholder: 'Search',
	        	maxHeight: 150
			});
		}
	});
}

function getUsersToShareReport(){
	$.ajax({
		url : '/reports/get_users_to_share_report/?which_report='+which_report+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#user_select").empty();
			$.each(data_arr, function(key, value) {
				 $('#user_select').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
			$('#user_select').on('change', function() {
				$(this).find('option:selected').each(
		            function(){
		            	
		            	if($('#row_' + this.value).length <= 0 && this.value != 'multiselect-all') {
		            		insertRowInSelectedEntryTable(this.value, $(this).text());
		            	}
		            });
				$(this).find('option:not(:selected)').each(
					 function(){
						 if($('#row_' + this.value).length > 0 && this.value != 'multiselect-all') {
			            	deselectEntry(this.value, selectedCategoryValue);
						 }
					 });
				if($(this).val() != null) {
					$('#selected_user_ids').attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_user_ids').attr('value','');
				}
			});
			$('#user_select').multiselect({
				includeSelectAllOption: true,
	        	enableCaseInsensitiveFiltering: true,
	        	maxHeight: 150
			});
			 
		}
	});
}
function changeElementSize(elementId) {
	$('#' + elementId).animate({height:'500px'}, 500);
}

function changeCategory() {
	selectedCategoryValue = $('#category_select').val();
	selectedCategoryText = $('#category_select option:selected').text();
	
	//add this line to point to user category, so the list always shows available users 
	//since we decided to hide groups for now
	selectedCategoryValue = 'user';
	if(selectedCategoryValue == 'group') {
		$('#group_select_div').show();
		$('#user_select_div').hide();
	}
	else {
		$('#user_select_div').show();
		$('#group_select_div').hide();
	}
}

function deselectEntry(entry, category) {
	$('#' + category + '_select').multiselect('deselect', entry);
	$('#' + category + '_select').multiselect('deselect', 'multiselect-all');
	var tr = $('#row_' + entry);
	var table = tr.parent();
	tr.css("background-color","#F5F5F5");
    tr.fadeOut(400, function(){
        tr.remove();
    });
	
	//figure out where to put focus now
	var row_count = table.children().length;
	if(row_count <= 2) {
		$('#share_select_users').focus();
	} else {
		if(tr.prev().children().children('a').length) { tr.prev().children().children('a').focus(); }
		else { tr.next().children().children('a').focus(); }
	}
	
    //assign adhoc form vlaues
    if($('#' + category + '_select').val() != null) {
		$('#selected_' + category + '_names').attr('value',$('#' + category + '_select').val().toString());
	}
	else {
		$('#selected_' + category + '_names').attr('value','');
	}
}

function insertRowInSelectedEntryTable(value, text) {
	$('#selected_entry_table').append('<tr id="row_'+ value + '">' +
		'<td><i style="color:#666666; font-size:15px" class="fa fa-user" title="User Name: ' + text +'"></i>&nbsp;&nbsp;' + text + '</td>' + 
		'<td align="center"><a href=# onclick="deselectEntry(\'' + value + '\',\'' + selectedCategoryValue + '\');" title="Remove Item"><i style="color:#666666; font-size:15px" class="fa fa-trash-o"><span style="font-size: 0; line-height: 0; color: transparent;">Remove Item</span></i></a></td></tr>');
	
}

function toggleShareMenu(passedReportAccess) {
	if(passedReportAccess == 'shared') {
		//this lets our menu hang over the dialog edge
		$('.ui-dialog').css('overflow','visible'); 
		$('.ui-dialog-content').css('overflow','visible');
		
		$('#share_div').fadeIn('slow');
		$('#category_select').multiselect();
		$('#share_select_users').focus();
	}
	else {
		$('#share_div').fadeOut('slow');
	}
	
}
// end of share view functions

//drop down time period change
function update_time_period(report_id) {

	var new_time_period = document.getElementById('time_period_' + report_id);

	var new_time_period_excel = document.getElementById('new_time_period_excel_' + report_id);
	new_time_period_excel.value = new_time_period.value;
	
	var new_time_period_pdf = document.getElementById('new_time_period_pdf_' + report_id);
	new_time_period_pdf.value = new_time_period.value;
	
	var new_time_period_print = document.getElementById('new_time_period_print_' + report_id);
	new_time_period_print.value = new_time_period.value;
	
	var new_time_period_detail = document.getElementById('new_time_period_detail_' + report_id);
	new_time_period_detail.value = new_time_period.value;

}
//Remove users on deleted reports
function shared_remove_user(user_id,report_id, name) {
	   var message = 'Do you really want to remove this user access from this report?';
        if (confirm(message)) {
		 $.ajax({
				url : '/reports/get_share_user_to_delete/?report_id='+ report_id +'&user_id='+ user_id+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
				success: function(data) {
					var data_arr = $.parseJSON(data);
					var modifiedTime = '';
					$.each(data_arr, function(key, value) {
						modifiedTime = value;
					});
					$('#modified_time' + report_id).html(modifiedTime);
					//on success, hide  element user wants to delete.
					$('#row_'+ user_id).fadeOut(1000,function(){ 
						$('#row_'+user_id).remove();                    
					}); 
					$('#report_table').dataTable().fnDestroy();
					initializeAdhocReportDatatable();
				},
				error:function (xhr, ajaxOptions, thrownError){
					//On error, we alert user
					alert(thrownError);
				}
		});
	}
}

function checkIfAnyCheckboxSelected() {
	var ifAnySelected = false;
	var checkboxes = jQuery(':input:checkbox');
	for(var i = 0; i < checkboxes.length; i++) {
		if(checkboxes[i].checked) {
			ifAnySelected = true;
			break;
		}
	}
	return ifAnySelected;
}

function enableAdhocReportFormMultipleButtons() {
	var report_id_delete_button = document.getElementById('report_id_delete_button');
	var export_pdf_button = document.getElementById('export_pdf_button');
	var export_excel_button = document.getElementById('export_excel_button');
	if(checkIfAnyCheckboxSelected()) {
		if(report_id_delete_button != null) {
			report_id_delete_button.disabled = false;
			report_id_delete_button.className = 'adhoc_button_submenu';
		}
		export_pdf_button.disabled = false;
		export_pdf_button.className = 'adhoc_button_submenu';
		export_excel_button.disabled = false;
		export_excel_button.className = 'adhoc_button_submenu';
	}
	else {
		if(report_id_delete_button != null) {
			report_id_delete_button.disabled = true;
			report_id_delete_button.className = 'adhoc_button_disabled';
		}
		export_pdf_button.disabled = true;
		export_pdf_button.className = 'adhoc_button_disabled';
		export_excel_button.disabled = true;
		export_excel_button.className = 'adhoc_button_disabled';
	}
	
}

function initializeAdhocReportDatatable() {
	$('#report_table').dataTable({
		//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
		"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,5,6]},
		                 { 'bSearchable': false, 'aTargets': [0,5,6]}],
		//set default sorting to Last Modified 2nd column, ascending
		"aaSorting": [[3,"desc"]],
		//set search box text
		"oLanguage": {
			"sSearch": "Find Report: ",
			 "sInfo": "Showing _START_ to _END_ of _TOTAL_ Reports",
			 "sLengthMenu":    "Showing _MENU_ Reports",
			 paginate: {
            first:      "First",
            previous:   "Previous",
            next:       "Next",
            last:       "Last"
        },
		 emptyTable:    "No matching reports were found",
		 zeroRecords:   "No matching reports were found",
		}
	});
}
